import {
    EBusesPlaceType,
    IBusesPlace,
} from 'types/buses/booking/IBusesBookParams';
import {ISchemaCell} from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/components/Schema/types';

function getPlaceType(
    place: IBusesPlace,
    driverPlace: IBusesPlace | null,
): EBusesPlaceType {
    if (place.type === EBusesPlaceType.DRIVER) {
        if (place === driverPlace) {
            return EBusesPlaceType.DRIVER;
        }

        return EBusesPlaceType.PASSAGE;
    }

    return place.type;
}

export default function getSchemaCellsByMap(
    placesMap: IBusesPlace[],
    driverPlace: IBusesPlace | null,
): ISchemaCell[][] {
    return placesMap.reduce<ISchemaCell[][]>((accSchemaCoords, place) => {
        accSchemaCoords[place.y] ||= [];

        accSchemaCoords[place.y][place.x] = {
            id: place.id,
            type: getPlaceType(place, driverPlace),
            status: place.status,
        };

        return accSchemaCoords;
    }, []);
}
