import times from 'lodash/times';
import last from 'lodash/last';

import {
    EBusesPlaceStatus,
    EBusesPlaceType,
} from 'types/buses/booking/IBusesBookParams';
import {ISchemaCell} from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/components/Schema/types';

const SCHEMA_ROWS = 4;

export default function getSchemaCellsBySeats(
    seats: string[],
): ISchemaCell[][] {
    const lastSeat = last(seats);
    const freeSeatsSet = new Set(seats);
    const allSeats = times(Number(lastSeat), s => String(s + 1));

    return allSeats.reduce<ISchemaCell[][]>((accSchemaCoords, seat, index) => {
        const x = Math.floor(index / SCHEMA_ROWS);
        const y = index % SCHEMA_ROWS;

        accSchemaCoords[y] ||= [];

        accSchemaCoords[y][x] = {
            id: seat,
            type: EBusesPlaceType.SEAT,
            status: freeSeatsSet.has(seat)
                ? EBusesPlaceStatus.FREE
                : EBusesPlaceStatus.OCCUPIED,
        };

        return accSchemaCoords;
    }, []);
}
