import {useMemo} from 'react';

import {
    EBusesBookGroup,
    EBusesPassengerFormFiled,
    IBusesPassenger,
} from 'types/buses/booking/IBusesBookFormValues';

import useMemoFormFieldValue from 'components/Form/hooks/useMemoFormFieldValue';

export default function useBaggagePlacesCount(): number {
    const passengersFormData = useMemoFormFieldValue<IBusesPassenger[]>(
        EBusesBookGroup.PASSENGERS,
    );

    return useMemo(
        () =>
            passengersFormData.reduce(
                (accBaggagePlacesCount, passenger) =>
                    accBaggagePlacesCount +
                    (Number(
                        passenger[EBusesPassengerFormFiled.BAGGAGE_COUNT],
                    ) || 0),
                0,
            ),
        [passengersFormData],
    );
}
