import * as i18n from 'i18n/buses-BookPage-Places';

export default function getMaxPlacesHintText({
    placesCount,
    ticketLimit,
    freeSeats,
    baggagePlacesCount,
}: {
    placesCount: number;
    ticketLimit: number;
    freeSeats: number;
    baggagePlacesCount: number;
}): string | null {
    if (placesCount + baggagePlacesCount === ticketLimit) {
        return i18n.maxPlacesHint({placesCount: ticketLimit});
    }

    if (placesCount === freeSeats) {
        return i18n.freeSeatsExceededHint();
    }

    return null;
}
