import {
    EBusesPlaceStatus,
    EBusesPlaceType,
    IBusesPlace,
} from 'types/buses/booking/IBusesBookParams';

export default function getFreeSeats(
    placesMap: IBusesPlace[],
    seats: string[],
    freeSeats: number | undefined,
): number {
    if (placesMap.length) {
        return placesMap.filter(
            placeMap =>
                placeMap.type === EBusesPlaceType.SEAT &&
                placeMap.status === EBusesPlaceStatus.FREE,
        ).length;
    }

    return seats.length || freeSeats || Infinity;
}
