import {memo, FC} from 'react';

import {IBusesCreateRideOfferResponse} from 'server/api/BusesTravelApi/types/TBusesCreateRideOfferApiResponse';

import Disclaimer from 'projects/buses/pages/booking/BookPage/components/RightColumn/components/Disclaimer/Disclaimer';
import Cart from 'projects/buses/pages/booking/BookPage/components/RightColumn/components/Cart/Cart';

import cx from './RightColumn.scss';

interface IRightColumnProps {
    rideOffer: IBusesCreateRideOfferResponse;
}

const RightColumn: FC<IRightColumnProps> = props => {
    const {rideOffer} = props;

    return (
        <>
            <Cart ticketTypes={rideOffer.bookParams.ticketTypes} />

            <Disclaimer className={cx('disclaimer')} ride={rideOffer.ride} />
        </>
    );
};

export default memo(RightColumn);
