import {FC, memo, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IBusesTicketType} from 'types/buses/booking/IBusesBookParams';
import {IBusesBookQuery} from 'types/buses/booking/IBusesBookQuery';

import useQuery from 'utilities/hooks/useQuery';
import getParsedQueryPlaces from 'projects/buses/pages/booking/BookPage/utilities/getParsedQueryPlaces';
import getGroupedTickets from 'projects/buses/pages/booking/BookPage/components/RightColumn/components/Cart/components/Tickets/utilities/getGroupedTickets';

import Box from 'components/Box/Box';
import TicketGroup from 'projects/buses/pages/booking/BookPage/components/RightColumn/components/Cart/components/Tickets/components/TicketGroup/TicketGroup';

interface ITicketsProps extends IWithClassName {
    tickets: IBusesTicketType[];
}

const Tickets: FC<ITicketsProps> = props => {
    const {className, tickets} = props;

    const {places: rawPlaces} = useQuery<keyof IBusesBookQuery>(['places']);

    const places = getParsedQueryPlaces(rawPlaces || undefined);

    const groupedTickets = useMemo(
        () => getGroupedTickets(tickets, places),
        [places, tickets],
    );

    return (
        <Box className={className} between={2}>
            {groupedTickets.map(ticketGroup => (
                <TicketGroup
                    key={ticketGroup.ticketType.type}
                    ticketGroup={ticketGroup}
                />
            ))}
        </Box>
    );
};

export default memo(Tickets);
