import {memo, FC, useMemo} from 'react';

import {convertPlacesToString} from 'projects/trains/lib/order/places/convertPlacesToString';
import {IBusesCartTicketGroup} from 'projects/buses/pages/booking/BookPage/components/RightColumn/components/Cart/components/Tickets/utilities/getGroupedTickets';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import getTicketTypeName from 'projects/buses/utilities/booking/getTicketTypeName';

import * as i18n from 'i18n/buses-BookPage-Cart';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import Price from 'components/Price/Price';

interface ITicketGroupProps {
    ticketGroup: IBusesCartTicketGroup;
}

const TicketGroup: FC<ITicketGroupProps> = props => {
    const {ticketGroup} = props;

    const placesText = useMemo(() => {
        const sortedPlaces = [...ticketGroup.places].sort(
            (p1, p2) => Number(p1) - Number(p2),
        );

        return convertPlacesToString({
            places: sortedPlaces,
            isLowerCase: true,
        });
    }, [ticketGroup.places]);

    return (
        <Flex
            key={ticketGroup.ticketType.type}
            justifyContent="space-between"
            textSize="s"
        >
            <Flex inline between={1}>
                <div>{getTicketTypeName(ticketGroup.ticketType.type)}</div>

                {Boolean(ticketGroup.places.length) && (
                    <Text size="inherit" color="secondary">
                        {placesText}
                    </Text>
                )}
            </Flex>

            <div>
                {insertJSXIntoKey(i18n.ticketGroupPrice)({
                    count: ticketGroup.count,
                    price: <Price {...ticketGroup.ticketType.fare.total} />,
                })}
            </div>
        </Flex>
    );
};

export default memo(TicketGroup);
