import {
    EBusesTicketType,
    IBusesTicketType,
} from 'types/buses/booking/IBusesBookParams';

export interface IBusesCartTicketGroup {
    ticketType: IBusesTicketType;
    count: number;
    places: string[];
}

const TICKET_TYPE_GROUP_INDEX_MAP = {
    [EBusesTicketType.FULL]: 0,
    [EBusesTicketType.CHILD]: 1,
    [EBusesTicketType.BAGGAGE]: 2,
};

export default function getGroupedTickets(
    tickets: IBusesTicketType[],
    places: string[],
): IBusesCartTicketGroup[] {
    const placesToAllocate = [...places];

    return tickets
        .reduce<IBusesCartTicketGroup[]>((accTickets, ticket) => {
            const ticketTypeGroupIndex =
                TICKET_TYPE_GROUP_INDEX_MAP[ticket.type];

            accTickets[ticketTypeGroupIndex] ||= {
                count: 0,
                ticketType: ticket,
                places: [],
            };

            accTickets[ticketTypeGroupIndex].count++;

            if (ticket.type !== EBusesTicketType.BAGGAGE) {
                const place = placesToAllocate.shift();

                if (place) {
                    accTickets[ticketTypeGroupIndex].places.push(place);
                }
            }

            return accTickets;
        }, [])
        .filter(Boolean);
}
