import {
    EBusesTicketType,
    IBusesTicketType,
} from 'types/buses/booking/IBusesBookParams';

export type TBusesTicketTypeMap = Record<EBusesTicketType, IBusesTicketType>;

export default function getTicketTypeMap(
    ticketTypes: IBusesTicketType[],
): TBusesTicketTypeMap {
    return ticketTypes.reduce<TBusesTicketTypeMap>(
        (accTicketTypeMap, ticketType) => {
            accTicketTypeMap[ticketType.type] = ticketType;

            return accTicketTypeMap;
        },
        {} as TBusesTicketTypeMap,
    );
}
