import times from 'lodash/times';

import {
    EBusesPassengerFormFiled,
    IBusesPassenger,
} from 'types/buses/booking/IBusesBookFormValues';
import {
    EBusesTicketType,
    IBusesTicketType,
} from 'types/buses/booking/IBusesBookParams';

import {TBusesTicketTypeMap} from 'projects/buses/pages/booking/BookPage/components/RightColumn/components/Cart/utilities/getTicketTypeMap';

export default function getTickets(
    passengers: IBusesPassenger[],
    ticketTypeMap: TBusesTicketTypeMap,
): IBusesTicketType[] {
    return passengers.reduce<IBusesTicketType[]>((accTickets, passenger) => {
        const passengerTariff = passenger[EBusesPassengerFormFiled.TARIFF];

        if (!passengerTariff) {
            return accTickets;
        }

        accTickets.push(ticketTypeMap[passengerTariff]);

        const baggageCount = Number(
            passenger[EBusesPassengerFormFiled.BAGGAGE_COUNT],
        );

        if (baggageCount) {
            accTickets.push(
                ...times(
                    baggageCount,
                    () => ticketTypeMap[EBusesTicketType.BAGGAGE],
                ),
            );
        }

        return accTickets;
    }, []);
}
