import IPrice from 'types/common/price/IPrice';
import {IBusesTicketType} from 'types/buses/booking/IBusesBookParams';

export default function getTotalPrice(
    tickets: IBusesTicketType[],
): IPrice | null {
    return tickets.reduce<IPrice | null>((accPrice, ticket) => {
        if (!accPrice) {
            return ticket.fare.total;
        }

        return {
            ...accPrice,
            value: accPrice.value + ticket.fare.total.value,
        };
    }, null);
}
