import IPrice from 'types/common/price/IPrice';
import {IBusesTicketType} from 'types/buses/booking/IBusesBookParams';

export default function getTotalYandexFee(
    tickets: IBusesTicketType[],
): IPrice | null {
    return tickets.reduce<IPrice | null>((accFee, ticket) => {
        if (!accFee) {
            return ticket.fare.yandexFee;
        }

        return {
            ...accFee,
            value: accFee.value + ticket.fare.yandexFee.value,
        };
    }, null);
}
