import {memo, FC, useMemo} from 'react';

import {YANDEX_REQUISITES} from 'constants/requisites';

import IPartnerRequisites from 'components/PartnersRequisites/types/IPartnerRequisites';
import {IWithClassName} from 'types/withClassName';
import {isNotNull} from 'types/utilities';
import {IBusesRide} from 'types/buses/booking/IBusesRide';

import preparePartner from 'components/PartnersRequisites/utilities/preparePartner';
import getCommonPartner from 'projects/buses/pages/booking/BookPage/components/RightColumn/components/Disclaimer/utilities/getCommonPartner';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18n from 'i18n/buses-BookPage-Cart';

import CartCaption from 'components/Layouts/BookingLayout/components/CartCaption/CartCaption';
import PartnersRequisites from 'components/PartnersRequisites/PartnersRequisites';
import Link from 'components/Link/Link';

import cx from './Disclaimer.scss';

interface IDisclaimerProps extends IWithClassName {
    ride: IBusesRide;
}

const BOOKING_CONDITIONS_LINK =
    'https://yandex.ru/legal/bus_tickets_booking_conditions/';

const Disclaimer: FC<IDisclaimerProps> = props => {
    const {className, ride} = props;

    const partners = useMemo((): IPartnerRequisites[] => {
        const {carrier, supplier} = ride;

        return [
            carrier
                ? preparePartner(
                      getCommonPartner(
                          carrier,
                          i18n.disclaimerPartnerCarrierTitlePrefix(),
                      ),
                  )
                : null,
            supplier
                ? preparePartner(
                      getCommonPartner(
                          supplier,
                          i18n.disclaimerPartnerSupplierTitlePrefix(),
                      ),
                  )
                : null,
            preparePartner(YANDEX_REQUISITES),
        ].filter(isNotNull);
    }, [ride]);

    return (
        <CartCaption className={className}>
            <div>
                {insertJSXIntoKey(i18n.disclaimerConditions)({
                    link: (
                        <Link
                            url={BOOKING_CONDITIONS_LINK}
                            target="_blank"
                            rel="noopener noreferrer"
                        >
                            {i18n.disclaimerConditionsLinkText()}
                        </Link>
                    ),
                })}
            </div>

            <PartnersRequisites
                className={cx('partners')}
                partners={partners}
            />
        </CartCaption>
    );
};

export default memo(Disclaimer);
