import {ILegalEntity} from 'types/buses/booking/IBusesRide';
import IRawPartnerData from 'projects/trains/components/TrainsOrderPage/PartnersRequisites/types/IRawPartnerData';

import * as i18n from 'i18n/buses-BookPage-Cart';

export default function getCommonPartner(
    legalEntity: ILegalEntity,
    titlePrefix: string,
): IRawPartnerData {
    const name = legalEntity.name || legalEntity.legalName;

    return {
        title: `${titlePrefix}${name ? ` ${name}` : ''}`,
        additionalFieldName: i18n.disclaimerPartnerRegisterNumberTitle(),
        additionalFieldNumber: legalEntity.registerNumber,
        factAddress: legalEntity.actualAddress,
        judicialAddress: legalEntity.legalAddress,
        time: legalEntity.timetable,
    };
}
