import {memo, FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import LeftColumnSkeleton from 'projects/buses/pages/booking/BookPage/components/Skeleton/components/LeftColumnSleleton/LeftColumnSkeleton';
import RightColumnSkeleton from 'projects/buses/pages/booking/BookPage/components/Skeleton/components/RightColumnSkeleton/RightColumnSkeleton';

interface ISkeletonProps extends IWithClassName {}

const Skeleton: FC<ISkeletonProps> = props => {
    const {className} = props;

    const deviceType = useDeviceType();

    return (
        <BookingLayout
            className={className}
            deviceType={deviceType}
            leftColumn={<LeftColumnSkeleton />}
            rightColumn={<RightColumnSkeleton />}
        />
    );
};

export default memo(Skeleton);
