import {memo, FC} from 'react';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import SegmentSkeleton from 'projects/buses/pages/booking/BookPage/components/Skeleton/components/LeftColumnSleleton/SegmentSkeleton/SegmentSkeleton';
import PassengersSkeleton from 'projects/buses/pages/booking/BookPage/components/Skeleton/components/LeftColumnSleleton/PassengersSkeleton/PassengersSkeleton';
import PlacesSkeleton from 'projects/buses/pages/booking/BookPage/components/Skeleton/components/LeftColumnSleleton/PlacesSkeleton/PlacesSkeleton';

interface ILeftColumnSkeletonProps {}

const LeftColumnSkeleton: FC<ILeftColumnSkeletonProps> = () => {
    return (
        <BookingLayout.Forms>
            <SegmentSkeleton />
            <PlacesSkeleton />
            <PassengersSkeleton />
        </BookingLayout.Forms>
    );
};

export default memo(LeftColumnSkeleton);
