import {memo, FC} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18n from 'i18n/buses-BookPage-Passengers';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import Text from 'components/Text/Text';
import FieldsSkeleton from 'components/BookingPassengerForm/components/skeletons/FieldsSkeleton/FieldsSkeleton';

import cx from './PassengersSkeleton.scss';

interface IPassengersSkeletonProps {}

const PassengersSkeleton: FC<IPassengersSkeletonProps> = () => {
    const deviceType = useDeviceType();

    return (
        <BookingLayout.Card
            className={cx('root', deviceMods('root', deviceType))}
        >
            <Text size="l" weight="bold">
                {i18n.passengerTitle({index: 1, place: ''})}
            </Text>

            <FieldsSkeleton className={cx('fields')} />
        </BookingLayout.Card>
    );
};

export default memo(PassengersSkeleton);
