import {memo, FC} from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18n from 'i18n/buses-BookPage-Places';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import Text from 'components/Text/Text';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';
import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './PlacesSkeleton.scss';

interface IPlacesSkeletonProps {}

const PlacesSkeleton: FC<IPlacesSkeletonProps> = () => {
    const deviceType = useDeviceType();

    return (
        <BookingLayout.Card
            className={cx('root', deviceMods('root', deviceType))}
        >
            <Text size="l" weight="bold">
                {i18n.title()}
            </Text>

            <div className={cx('animationArea')}>
                <Flex
                    flexDirection={deviceType.isMobile ? 'row' : 'row-reverse'}
                    justifyContent={
                        deviceType.isMobile ? 'flex-start' : 'flex-end'
                    }
                    alignItems="center"
                    above={deviceType.isMobile ? 4 : 5}
                >
                    <div className={cx('selectorDescription')}>
                        <TextSkeleton
                            className={cx('selectorDescriptionFirstRow')}
                        />

                        <TextSkeleton
                            className={cx('selectorDescriptionSecondRow')}
                        />
                    </div>

                    <Flex className={cx('selector')}>
                        <ButtonSkeleton size="l" shape="circle" />

                        <ButtonSkeleton
                            className={cx('increaseButton')}
                            size="l"
                            shape="circle"
                        />
                    </Flex>
                </Flex>

                <TextSkeleton className={cx('schemaDescriptionFirstRow')} />
                <TextSkeleton className={cx('schemaDescriptionSecondRow')} />
            </div>
        </BookingLayout.Card>
    );
};

export default memo(PlacesSkeleton);
