import {memo, FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import Flex from 'components/Flex/Flex';
import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import PointSkeleton from 'projects/buses/pages/booking/BookPage/components/Skeleton/components/LeftColumnSleleton/SegmentSkeleton/DesktopSegmentSkeleton/components/PointSkeleton/PointSkeleton';
import Box from 'components/Box/Box';

import cx from './DesktopSegmentSkeleton.scss';

interface IDesktopSegmentSkeletonProps extends IWithClassName {}

const DesktopSegmentSkeleton: FC<IDesktopSegmentSkeletonProps> = props => {
    const {className} = props;

    return (
        <BookingLayout.Card className={className} between={5}>
            <TextSkeleton className={cx('title')} size="xl" />

            <Flex inline between={4}>
                <PointSkeleton />
                <PointSkeleton />

                <Box between={1}>
                    <TextSkeleton className={cx('duration')} />
                    <TextSkeleton className={cx('carrier')} />
                </Box>
            </Flex>
        </BookingLayout.Card>
    );
};

export default memo(DesktopSegmentSkeleton);
