import {memo, FC} from 'react';

import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './PointSkeleton.scss';

interface IPointSkeletonProps {}

const PointSkeleton: FC<IPointSkeletonProps> = () => {
    return (
        <div className={cx('root')}>
            <TextSkeleton className={cx('time')} size="xl" />
            <TextSkeleton className={cx('addressFirstLine')} />
            <TextSkeleton className={cx('addressSecondLine')} />
        </div>
    );
};

export default memo(PointSkeleton);
