import {FC, memo} from 'react';

import {IWithClassName} from 'types/withClassName';

import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import Flex from 'components/Flex/Flex';
import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import Separator from 'components/Separator/Separator';

import cx from './MobileSegmentSkeleton.scss';

interface IMobileSegmentSkeletonProps extends IWithClassName {}

const MobileSegmentSkeleton: FC<IMobileSegmentSkeletonProps> = props => {
    const {className} = props;

    return (
        <BookingLayout.Card className={cx('root', className)}>
            <TextSkeleton className={cx('direction')} size="l" />
            <TextSkeleton className={cx('date')} />

            <Separator margin={3} />

            <Flex justifyContent="space-between">
                <TextSkeleton className={cx('pointDate')} size="xs" />
                <TextSkeleton className={cx('pointDate')} size="xs" />
            </Flex>

            <Flex>
                <TextSkeleton className={cx('pointTime')} size="l" />

                <Flex className={cx('durationWrapper')} alignItems="center">
                    <Separator className={cx('durationSeparator')} />
                    <TextSkeleton className={cx('duration')} size="s" />
                    <Separator className={cx('durationSeparator')} />
                </Flex>

                <TextSkeleton className={cx('pointTime')} size="l" />
            </Flex>

            <TextSkeleton className={cx('departureAddress')} />
            <TextSkeleton className={cx('arrivalAddress')} />
        </BookingLayout.Card>
    );
};

export default memo(MobileSegmentSkeleton);
