import {memo, FC} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import MobileSegmentSkeleton from 'projects/buses/pages/booking/BookPage/components/Skeleton/components/LeftColumnSleleton/SegmentSkeleton/MobileSegmentSkeleton/MobileSegmentSkeleton';
import DesktopSegmentSkeleton from 'projects/buses/pages/booking/BookPage/components/Skeleton/components/LeftColumnSleleton/SegmentSkeleton/DesktopSegmentSkeleton/DesktopSegmentSkeleton';

import cx from './SegmentSkeleton.scss';

interface ISegmentSkeletonProps {}

const SegmentSkeleton: FC<ISegmentSkeletonProps> = () => {
    const deviceType = useDeviceType();

    if (deviceType.isMobile) {
        return <MobileSegmentSkeleton className={cx('root')} />;
    }

    return <DesktopSegmentSkeleton className={cx('root')} />;
};

export default memo(SegmentSkeleton);
