import {memo, FC} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import Separator from 'components/Separator/Separator';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './RightColumnSkeleton.scss';

interface IRightColumnSkeletonProps {}

const RightColumnSkeleton: FC<IRightColumnSkeletonProps> = () => {
    const deviceType = useDeviceType();

    if (deviceType.isMobile) {
        return null;
    }

    return (
        <BookingLayout.Cart className={cx('root')}>
            <TextSkeleton size="l" />
            <TextSkeleton size="s" className={cx('passenger')} />
            <Separator margin={5} />
            <TextSkeleton className={cx('price')} size="xl" />
            <ButtonSkeleton className={cx('button')} size="xl" />
        </BookingLayout.Cart>
    );
};

export default memo(RightColumnSkeleton);
