import {
    EBusesTicketType,
    IBusesTicketType,
} from 'types/buses/booking/IBusesBookParams';
import IPrice from 'types/common/price/IPrice';

export default function getBaggagePrice(
    ticketTypes: IBusesTicketType[],
): IPrice | null {
    const baggageTicketType = ticketTypes.find(
        t => t.type === EBusesTicketType.BAGGAGE,
    );

    return baggageTicketType?.fare.total || null;
}
