import {ServerDataFetcherBag} from 'server/redux/types';
import {IBusesBookQuery} from 'types/buses/booking/IBusesBookQuery';

import requestBookPageInfoAction from 'reducers/buses/book/thunk/requestBookPageInfoAction';

export async function requestBookPageInfoSSR(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {
        req,
        req: {query},
        dispatch,
    } = serverFetcherData;
    const {rideId, from, to, when} = query as IBusesBookQuery;

    if (!rideId || !from || !to || !when) {
        return;
    }

    await dispatch(
        requestBookPageInfoAction({
            req,
            params: {
                rideId,
                from,
                to,
                when,
            },
            isSSR: true,
        }),
    );
}
