import {useMemo} from 'react';

import * as i18nOrderPaymentBlock from 'i18n/trains-order-payment';

interface IOwnLoader {
    isVisible: boolean;
    text: string;
}

export default function useOwnLoader({
    isFrameLoaded,
    isPaymentCompleted,
    isTrustPaymentError,
    isPaymentFailed,
}: {
    isFrameLoaded: boolean;
    isPaymentCompleted: boolean;
    isTrustPaymentError: boolean;
    isPaymentFailed: boolean;
}): IOwnLoader {
    return useMemo(() => {
        if (!isFrameLoaded || isTrustPaymentError || isPaymentFailed) {
            return {
                isVisible: true,
                text: i18nOrderPaymentBlock.waiterDashReservationDashText(),
            };
        }

        if (isPaymentCompleted) {
            return {
                isVisible: true,
                text: i18nOrderPaymentBlock.waiterDashSuccessDashText(),
            };
        }

        return {
            isVisible: false,
            text: '',
        };
    }, [
        isFrameLoaded,
        isPaymentCompleted,
        isPaymentFailed,
        isTrustPaymentError,
    ]);
}
