import {FC, memo, useEffect, useMemo} from 'react';
import {useDispatch} from 'react-redux';

import {EProjectName} from 'constants/common';

import {IHappyPageBusApiResponse} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';

import {setIsNewTrip} from 'reducers/trips/tripPage/actions';

import getBusService from 'projects/buses/utilities/booking/getBusService';

import HappyPageContentBase from 'src/projects/happyPage/components/HappyPageContent/HappyPageContent';
import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import OrderSegment from 'projects/buses/components/OrderSegment/OrderSegment';
import OrderActions from 'projects/buses/components/OrderActions/OrderActions';
import {EOrderActionsSource} from 'components/OrderActions/OrderActions';

interface IHappyPageContentProps {
    orderAndCrossSalesInfo: IHappyPageBusApiResponse;
}

const HappyPageContent: FC<IHappyPageContentProps> = props => {
    const {
        orderAndCrossSalesInfo: {order, crossSale},
    } = props;

    const dispatch = useDispatch();

    const busService = useMemo(
        () => getBusService(order.services),
        [order.services],
    );

    const ride = busService?.busInfo.ride;
    const downloadBlankToken = busService?.busInfo.downloadBlankToken;

    const orderInfo = useMemo(() => {
        if (!ride) {
            return null;
        }

        return (
            <CardWithDeviceLayout>
                <OrderSegment ride={ride} />
            </CardWithDeviceLayout>
        );
    }, [ride]);

    const orderActions = useMemo(() => {
        return (
            <OrderActions
                source={EOrderActionsSource.HAPPY_PAGE}
                orderId={order.id}
                downloadBlankToken={downloadBlankToken}
            />
        );
    }, [downloadBlankToken, order.id]);

    useEffect(() => {
        dispatch(setIsNewTrip(true));
    }, [dispatch]);

    return (
        <HappyPageContentBase
            orderType={EProjectName.BUSES}
            orderInfo={orderInfo}
            orderActions={orderActions}
            crossSale={crossSale}
            prettyOrderId={order.prettyId}
            email={order.contactInfo.email}
        />
    );
};

export default memo(HappyPageContent);
