import {FC} from 'react';
import {useLocation} from 'react-router-dom';

import {getAbsoluteUrl} from 'utilities/url';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

// TODO: add title for DocumentMeta
const BookMeta: FC = () => {
    const {pathname, search} = useLocation();

    return (
        <>
            <DocumentMeta />
            <SocialSharingMeta url={getAbsoluteUrl(pathname, search)} />
        </>
    );
};

export default BookMeta;
