import React from 'react';

import {IFilledContextPoint} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';

import getCityPageUrl from 'projects/buses/utilities/urls/getCityUrl';

import * as i18nBlock from 'i18n/buses-cityPage';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

interface IHelmetProps {
    city: IFilledContextPoint;
}

const Helmet: React.FC<IHelmetProps> = props => {
    const {city} = props;

    const from = city.titleGenitive || '';

    const title = i18nBlock.metaTitle({from});
    const description = i18nBlock.metaDescription({from});

    const canonicalUrl = getCityPageUrl({
        slug: city.slug,
        options: {
            withOrigin: true,
        },
    });

    return (
        <>
            <DocumentMeta
                title={title}
                description={description}
                canonicalUrl={canonicalUrl}
            />

            <SocialSharingMeta
                url={canonicalUrl}
                title={title}
                description={description}
            />
        </>
    );
};

export default Helmet;
