import pathToRegExp from 'path-to-regexp';

import {URLs} from 'constants/urls';

import {ServerDataFetcherBag} from 'server/redux/types';

import initCityPageThunkAction from 'reducers/buses/city/thunk/initCityPageThunkAction';
import {requestPopularDirectionsThunkAction} from 'reducers/buses/popularDirections/thunk/requestPopularDirectionsThunkAction';

const CITY_REGEXP = pathToRegExp(URLs.busesCity);

export default async function prefetchData(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {
        req,
        req: {path},
        dispatch,
        getState,
    } = serverFetcherData;

    const {1: slug} = CITY_REGEXP.exec(path) || [];

    if (!slug) {
        return;
    }

    await dispatch(initCityPageThunkAction(slug, req));

    const {
        buses: {
            city: {
                point: {value: city},
            },
        },
    } = getState();

    if (!city) {
        return;
    }

    await dispatch(
        requestPopularDirectionsThunkAction({req, fromId: city.key}),
    );
}
