import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nCommonFiltersBlock from 'i18n/common-filters';

import Flex from 'components/Flex/Flex';
import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import Box from 'components/Box/Box';
import FilterCheckList from 'components/FilterCheckList/FilterCheckList';

import cx from './DepartureAndArrivalStationFilter.scss';

interface IDepartureAndArrivalStationFilterProps {
    departureValue: string[];
    departureOptions: string[];
    departureAvailableOptions: string[];
    onDepartureChange(option: string): void;
    arrivalValue: string[];
    arrivalOptions: string[];
    arrivalAvailableOptions: string[];
    onArrivalChange(option: string): void;
}

const DepartureAndArrivalStationFilter: React.FC<IDepartureAndArrivalStationFilterProps> =
    props => {
        const {
            departureValue,
            departureOptions,
            departureAvailableOptions,
            onDepartureChange,
            arrivalValue,
            arrivalOptions,
            arrivalAvailableOptions,
            onArrivalChange,
        } = props;

        const deviceType = useDeviceType();

        if (departureOptions.length === 1 && arrivalOptions.length === 1) {
            return null;
        }

        return (
            <DropdownFilter
                label={i18nCommonFiltersBlock.departureAndArrivalStations()}
                checked={Boolean(departureValue.length || arrivalValue.length)}
            >
                <Flex className={cx('popupWrapper')} inline>
                    {departureOptions.length > 1 && (
                        <Box className={cx('departure')} between={3}>
                            <Box textSize="m" textWeight="bold">
                                {i18nCommonFiltersBlock.departure()}
                            </Box>

                            <FilterCheckList
                                deviceType={deviceType}
                                values={departureValue}
                                options={departureOptions}
                                availableValues={departureAvailableOptions}
                                onChange={onDepartureChange}
                            />
                        </Box>
                    )}

                    {arrivalOptions.length > 1 && (
                        <Box className={cx('arrival')} between={3}>
                            <Box textSize="m" textWeight="bold">
                                {i18nCommonFiltersBlock.arrival()}
                            </Box>

                            <FilterCheckList
                                deviceType={deviceType}
                                values={arrivalValue}
                                options={arrivalOptions}
                                availableValues={arrivalAvailableOptions}
                                onChange={onArrivalChange}
                            />
                        </Box>
                    )}
                </Flex>
            </DropdownFilter>
        );
    };

export default React.memo(DepartureAndArrivalStationFilter);
