import React from 'react';

import {ETimeOfDay} from 'utilities/dateUtils/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nCommonFiltersBlock from 'i18n/common-filters';

import TimeFilter from 'components/TimeFilter/TimeFilter';
import Box from 'components/Box/Box';
import DropdownFilter from 'components/DropdownFilter/DropdownFilter';

import cx from './DepartureAndArrivalTimeFilter.scss';

interface IDepartureAndArrivalTimeFilterProps {
    departureValue: ETimeOfDay[];
    departureOptions: ETimeOfDay[];
    departureAvailableOptions: ETimeOfDay[];
    onDepartureChange(option: ETimeOfDay): void;
    arrivalValue: ETimeOfDay[];
    arrivalOptions: ETimeOfDay[];
    arrivalAvailableOptions: ETimeOfDay[];
    onArrivalChange(option: ETimeOfDay): void;
}

const DepartureAndArrivalTimeFilter: React.FC<IDepartureAndArrivalTimeFilterProps> =
    props => {
        const {
            departureValue,
            departureOptions,
            departureAvailableOptions,
            onDepartureChange,
            arrivalValue,
            arrivalOptions,
            arrivalAvailableOptions,
            onArrivalChange,
        } = props;

        const deviceType = useDeviceType();

        if (departureOptions.length === 1 && arrivalOptions.length === 1) {
            return null;
        }

        return (
            <DropdownFilter
                label={i18nCommonFiltersBlock.departureAndArrivalTime()}
                checked={Boolean(departureValue.length || arrivalValue.length)}
            >
                <Box className={cx('popupWrapper')} between={7}>
                    <TimeFilter
                        deviceType={deviceType}
                        title={i18nCommonFiltersBlock.departure()}
                        value={departureValue}
                        availableValues={departureAvailableOptions}
                        options={departureOptions}
                        onChange={onDepartureChange}
                    />

                    <TimeFilter
                        deviceType={deviceType}
                        title={i18nCommonFiltersBlock.arrival()}
                        value={arrivalValue}
                        availableValues={arrivalAvailableOptions}
                        options={arrivalOptions}
                        onChange={onArrivalChange}
                    />
                </Box>
            </DropdownFilter>
        );
    };

export default React.memo(DepartureAndArrivalTimeFilter);
