import React from 'react';

import * as i18nCommonFiltersBlock from 'i18n/common-filters';

import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import CommonPriceFilter from 'components/PriceFilter/PriceFilter';

import cx from './PriceFilter.scss';

interface IDropdownPriceFilterProps {
    values: [number, number];
    rangeValues: [number, number];
    onChange(value: [number, number]): void;
}

const PriceFilter: React.FC<IDropdownPriceFilterProps> = props => {
    const {values, rangeValues, onChange} = props;

    const [selectedMin, selectedMax] = values;
    const [min, max] = rangeValues;

    return (
        <DropdownFilter
            popupClassName={cx('popup')}
            label={i18nCommonFiltersBlock.price()}
            checked={min !== selectedMin || max !== selectedMax}
        >
            <CommonPriceFilter
                values={values}
                rangeValues={rangeValues}
                onChange={onChange}
            />
        </DropdownFilter>
    );
};

export default React.memo(PriceFilter);
