import React, {useMemo} from 'react';

import {IBusesFilters} from 'types/buses/search/filters/IBusesFilters';
import {ETimeOfDay} from 'utilities/dateUtils/types';

import {IBusesSearchSortSelector} from 'selectors/buses/search/searchSortSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import FiltersAndSortsMobile from 'components/FiltersAndSortsMobile/FiltersAndSortsMobile';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';
import ModalContent from 'projects/buses/pages/search/SearchDatePage/components/Filters/components/FiltersMobile/components/ModalContent/ModalContent';

import cx from './FiltersMobile.scss';

interface IFiltersMobileProps extends IWithQaAttributes {
    itemsCount: number;
    activeFiltersCount: number;
    sortInfo: IBusesSearchSortSelector;
    filters: IBusesFilters | null;
    isLoading: boolean;
    onPriceChange(values: [number, number]): void;
    onDepartureTimeChange(option: ETimeOfDay): void;
    onArrivalTimeChange(option: ETimeOfDay): void;
    onDepartureStationChange(option: string): void;
    onArrivalStationChange(option: string): void;
    onReset(): void;
}

const FiltersMobile: React.FC<IFiltersMobileProps> = props => {
    const {
        itemsCount,
        activeFiltersCount,
        sortInfo,
        filters,
        isLoading,
        onPriceChange,
        onDepartureTimeChange,
        onArrivalTimeChange,
        onDepartureStationChange,
        onArrivalStationChange,
        onReset,
    } = props;

    const skeleton = useMemo(() => {
        if (!isLoading) {
            return null;
        }

        return (
            <ButtonSkeleton
                className={cx('skeleton')}
                size="xl"
                withAnimation
            />
        );
    }, [isLoading]);

    return (
        <FiltersAndSortsMobile
            className={cx('button')}
            activeFiltersCount={activeFiltersCount}
            itemsCount={itemsCount}
            isCompact
            skeleton={skeleton}
            onReset={onReset}
            {...prepareQaAttributes(props)}
        >
            {!isLoading && filters && (
                <ModalContent
                    filters={filters}
                    sortInfo={sortInfo}
                    onPriceChange={onPriceChange}
                    onDepartureTimeChange={onDepartureTimeChange}
                    onArrivalTimeChange={onArrivalTimeChange}
                    onDepartureStationChange={onDepartureStationChange}
                    onArrivalStationChange={onArrivalStationChange}
                />
            )}
        </FiltersAndSortsMobile>
    );
};

export default React.memo(FiltersMobile);
