import {IBusesFilters} from 'types/buses/search/filters/IBusesFilters';
import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';

export default function getActiveFiltersCount(filters: IBusesFilters): number {
    return Object.entries(filters).filter(([filterType, filter]) => {
        if (filterType === EBusesFilter.PRICE) {
            return (
                filter.value &&
                filter.range &&
                (filter.value[0] !== filter.range[0] ||
                    filter.value[1] !== filter.range[1])
            );
        }

        return filter.value.length;
    }).length;
}
