import {IBusesFilters} from 'types/buses/search/filters/IBusesFilters';
import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';

export default function isAnyFilterAvailable(filters: IBusesFilters): boolean {
    return Object.entries(filters).some(([type, filter]) => {
        if (type === EBusesFilter.PRICE) {
            return filter.range !== null;
        }

        return filter.options.length > 1;
    });
}
