import React from 'react';

import {IBusesFilledContext} from 'types/buses/common/IBusesContext';

import {formatDate} from 'utilities/dateUtils';
import {HUMAN} from 'utilities/dateUtils/formats';
import getSearchUrl from 'projects/buses/utilities/urls/getSearchUrl';

import * as i18nBlock from 'i18n/buses-SearchPage';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

interface IHelmetProps {
    context: IBusesFilledContext;
}

const Helmet: React.FC<IHelmetProps> = props => {
    const {
        context: {from, to, when},
    } = props;

    if (!when) {
        return null;
    }

    const departure = from.popularTitle || from.title;
    const arrival = to.popularTitle || to.title;
    const ogUrl = getSearchUrl({
        fromSlug: from.slug,
        toSlug: to.slug,
        when,
        options: {
            withOrigin: true,
        },
    });
    const canonicalUrl = getSearchUrl({
        fromSlug: from.slug,
        toSlug: to.slug,
        options: {
            withOrigin: true,
        },
    });

    const title = i18nBlock.seoTitle({
        departure,
        arrival,
        date: formatDate(when, HUMAN),
    });

    const description = i18nBlock.seoDescription({
        departure,
        arrival,
    });

    return (
        <>
            <DocumentMeta
                title={title}
                description={description}
                canonicalUrl={canonicalUrl}
            />

            <SocialSharingMeta
                url={ogUrl}
                title={title}
                description={description}
            />
        </>
    );
};

export default React.memo(Helmet);
