import React, {useCallback} from 'react';

import {IBusesFilledContext} from 'types/buses/common/IBusesContext';
import {EBusesGoal} from 'utilities/metrika/types/goals/buses';

import {reachGoal} from 'utilities/metrika';
import {humanFormatDate} from 'utilities/dateUtils';

import * as i18nCommonBlock from 'i18n/common';
import * as i18nUpdateNotificationBlock from 'i18n/buses-UpdateNotification';

import BaseUpdateNotification from 'components/UpdateNotification/UpdateNotification';

interface IUpdateNotificationProps {
    context: IBusesFilledContext;
}

const UpdateNotification: React.FC<IUpdateNotificationProps> = props => {
    const {context} = props;

    const handleShowNotification = useCallback(() => {
        reachGoal(EBusesGoal.SEARCH_EXPIRED);
    }, []);

    const handleUpdateNotification = useCallback(() => {
        reachGoal(EBusesGoal.SEARCH_EXPIRED_REFRESH);
    }, []);

    const handleUpdateNotificationSkip = useCallback(() => {
        reachGoal(EBusesGoal.SEARCH_EXPIRED_CONTINUE);
    }, []);

    if (!context.when) {
        return null;
    }

    const text = i18nUpdateNotificationBlock.textWithContext({
        date: humanFormatDate(context.when),
        direction: i18nCommonBlock.direction({
            from: context.from.popularTitle || context.from.title,
            to: context.to.popularTitle || context.to.title,
        }),
    });

    return (
        <BaseUpdateNotification
            text={text}
            onShowNotification={handleShowNotification}
            onUpdate={handleUpdateNotification}
            onSkip={handleUpdateNotificationSkip}
        />
    );
};

export default UpdateNotification;
