import moment from 'moment-timezone';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import isSpecialWhen from 'utilities/dateUtils/when/isSpecialWhen';

export default function isOutdatedOrWrongWhen(
    when: string | WHEN_SPECIAL_VALUE,
    timezone: string,
): boolean {
    if (isSpecialWhen(when)) {
        return false;
    }

    const whenMoment = moment.tz(when, timezone);

    if (!whenMoment.isValid()) {
        return true;
    }

    return whenMoment.isBefore(moment().tz(timezone), 'day');
}
