import {ServerDataFetcherBag} from 'server/redux/types';

import isOutdatedOrWrongWhen from 'projects/buses/pages/search/SearchDatePage/utilities/isOutdatedOrWrongWhen';
import getIndexUrl from 'projects/buses/utilities/urls/getIndexUrl';

import setSorts from 'server/redux/buses/setSorts';
import setFilters from 'server/redux/buses/setFilters';
import fetchContextFromPath from 'server/redux/buses/fetchContextFromPath';
import fillSearchFormBySearchContext from 'server/redux/buses/fillSearchFormBySearchContext';

export default async function prefetchData(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {res, getState} = serverFetcherData;

    await fetchContextFromPath(serverFetcherData);
    await fillSearchFormBySearchContext(serverFetcherData);

    const {
        buses: {
            context: {value: context},
        },
    } = getState();

    if (!context?.when) {
        return;
    }

    if (isOutdatedOrWrongWhen(context.when, context.from.timezone)) {
        res.redirect(
            302,
            getIndexUrl({
                query: {
                    fromSlug: context.from.slug,
                    toSlug: context.to.slug,
                },
            }),
        );

        return;
    }

    await setSorts(serverFetcherData);
    await setFilters(serverFetcherData);
}
