import {useEffect} from 'react';

import {IBusesSearchSegmentsStore} from 'reducers/buses/types/search/IBusesSearchSegmentsStore';

import {useBoolean} from 'utilities/hooks/useBoolean';

export default function useExpandSearchForm(
    segmentsInfo: IBusesSearchSegmentsStore,
): boolean {
    const {
        value: searchFormIsExpanded,
        setTrue: expandSearchForm,
        setFalse: hideSearchForm,
    } = useBoolean(false);

    useEffect(() => {
        if (
            segmentsInfo.isFetched &&
            !segmentsInfo.value?.length &&
            !segmentsInfo.error
        ) {
            expandSearchForm();
        }

        return (): void => {
            if (searchFormIsExpanded) {
                hideSearchForm();
            }
        };
    }, [segmentsInfo, expandSearchForm, hideSearchForm, searchFormIsExpanded]);

    return searchFormIsExpanded;
}
