import {useDispatch} from 'react-redux';
import {useEffect, useCallback, useRef} from 'react';

import {initSearchDateAction} from 'reducers/buses/search/actions';

export default function useInitSearch(
    fromSlug: string,
    toSlug: string,
    originWhen: string,
    lastSearchTimeMarker: string | undefined,
): () => void {
    const dispatch = useDispatch();

    const usedLastSearchTimeMarker = useRef<string | null>(null);

    const initSearch = useCallback(() => {
        if (!fromSlug || !toSlug || !originWhen) {
            return;
        }

        dispatch(
            initSearchDateAction({
                fromSlug,
                toSlug,
                originWhen,
            }),
        );
    }, [dispatch, fromSlug, toSlug, originWhen]);

    useEffect(() => {
        if (lastSearchTimeMarker === usedLastSearchTimeMarker.current) {
            return;
        }

        initSearch();
        usedLastSearchTimeMarker.current = lastSearchTimeMarker || null;
    }, [initSearch, lastSearchTimeMarker]);

    return initSearch;
}
