import {useEffect} from 'react';

import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';
import {IBusesSearchSegmentsStore} from 'reducers/buses/types/search/IBusesSearchSegmentsStore';
import {EBusesGoal} from 'utilities/metrika/types/goals/buses';

import {IBusesSearchFiltersSelector} from 'selectors/buses/search/searchFiltersSelector';

import {reachGoal} from 'utilities/metrika';
import {usePrevious} from 'utilities/hooks/usePrevious';

export default function useMetrika(
    segmentsInfo: IBusesSearchSegmentsStore,
    filtersInfo: IBusesSearchFiltersSelector | null,
): void {
    const prevIsFetched = usePrevious(segmentsInfo.isFetched);

    useEffect(() => {
        if (
            prevIsFetched === segmentsInfo.isFetched ||
            !segmentsInfo.isFetched
        ) {
            return;
        }

        reachGoal(EBusesGoal.SEARCH_DATE);

        if (!segmentsInfo.value?.length) {
            reachGoal(EBusesGoal.SEARCH_EMPTY);
        }

        if (filtersInfo) {
            if (filtersInfo.filters[EBusesFilter.PRICE].range) {
                reachGoal(EBusesGoal.SEARCH_FILTER_PRICE_SHOW);
            }

            if (
                filtersInfo.filters[EBusesFilter.DEPARTURE_TIME].options
                    .length > 1
            ) {
                reachGoal(EBusesGoal.SEARCH_FILTER_DEPARTURE_TIME_SHOW);
            }

            if (
                filtersInfo.filters[EBusesFilter.ARRIVAL_TIME].options.length >
                1
            ) {
                reachGoal(EBusesGoal.SEARCH_FILTER_ARRIVAL_TIME_SHOW);
            }

            if (
                filtersInfo.filters[EBusesFilter.DEPARTURE_STATION].options
                    .length > 1
            ) {
                reachGoal(EBusesGoal.SEARCH_FILTER_DEPARTURE_STATION_SHOW);
            }

            if (
                filtersInfo.filters[EBusesFilter.ARRIVAL_STATION].options
                    .length > 1
            ) {
                reachGoal(EBusesGoal.SEARCH_FILTER_ARRIVAL_STATION_SHOW);
            }
        }
    }, [prevIsFetched, segmentsInfo, filtersInfo]);
}
