import {useEffect} from 'react';
import {useDispatch} from 'react-redux';

import {
    EBusesSortDirection,
    EBusesSortType,
} from 'types/buses/search/EBusesSortType';
import {IBusesSearchSortStore} from 'reducers/buses/types/search/IBusesSearchSortStore';

import {setSortAction} from 'reducers/buses/search/sort/actions';

export default function useUpdateSort(
    sort: IBusesSearchSortStore,
    sortBy: EBusesSortType | undefined = EBusesSortType.DEPARTURE,
    sortDirection: EBusesSortDirection | undefined = EBusesSortDirection.ASC,
): void {
    const dispatch = useDispatch();

    useEffect(() => {
        if (sortBy !== sort.type || sortDirection !== sort.direction) {
            dispatch(
                setSortAction({
                    type: sortBy,
                    direction: sortDirection,
                }),
            );
        }
    }, [dispatch, sortBy, sortDirection, sort.type, sort.direction]);
}
