import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IBusesCrossLinks} from 'types/buses/direction/IBusesCrossLinksBlock';

import getSearchUrl from 'projects/buses/utilities/urls/getSearchUrl';

import * as i18nBlock from 'i18n/common';

import CommonCrossLinks from 'components/CrossLinks/CrossLinks';

interface ICrossLinksProps extends IWithClassName {
    crossLinks: IBusesCrossLinks;
}

const CrossLinks: React.FC<ICrossLinksProps> = props => {
    const {
        className,
        crossLinks: {crossLinks},
    } = props;

    const formattedItems = useMemo(
        () =>
            crossLinks.map(({fromTitle, toTitle, fromSlug, toSlug}) => ({
                text: i18nBlock.direction({
                    from: fromTitle,
                    to: toTitle,
                }),
                url: getSearchUrl({fromSlug, toSlug}),
            })),
        [crossLinks],
    );

    if (!formattedItems?.length) {
        return null;
    }

    return <CommonCrossLinks className={className} items={formattedItems} />;
};

export default React.memo(CrossLinks);
