import {FunctionComponent} from 'react';
import times from 'lodash/times';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import SegmentSkeleton from 'projects/buses/pages/search/components/Segments/components/SegmentSkeleton/SegmentSkeleton';

import cx from './SegmentsSkeleton.scss';

const SKELETON_SEGMENTS_COUNT = 4;

interface ISegmentsSkeletonProps extends IWithClassName {}

const SegmentsSkeleton: FunctionComponent<ISegmentsSkeletonProps> = ({
    className,
}) => {
    const {isMobile} = useDeviceType();

    return (
        <Box className={className} between={5}>
            {isMobile ? (
                <div>
                    <TextSkeleton
                        className={cx('titleSkeletonFirstRow')}
                        size="l"
                        withAnimation
                    />

                    <TextSkeleton
                        className={cx('titleSkeletonSecondRow')}
                        size="l"
                        withAnimation
                    />
                </div>
            ) : (
                <TextSkeleton size="xl" withAnimation />
            )}
            <Box between={3} above={5}>
                {times(SKELETON_SEGMENTS_COUNT).map(index => (
                    <SegmentSkeleton key={index} />
                ))}
            </Box>
        </Box>
    );
};

export default SegmentsSkeleton;
