import {ServerDataFetcherBag} from 'server/redux/types';

import {fetchDirectionPageInfo} from 'reducers/buses/directionPage/thunk/fetchDirectionPageInfo';

export default function prefetchData(fromSlug: string, toSlug: string) {
    return async function (
        serverFetcherData: ServerDataFetcherBag,
    ): Promise<void> {
        const {req, dispatch} = serverFetcherData;

        await dispatch(fetchDirectionPageInfo(fromSlug, toSlug, req));
    };
}
