import React, {useMemo} from 'react';

import {
    EBusesSearchBookingInfoStatus,
    IBusesSearchBookingInfoStore,
} from 'reducers/buses/types/search/IBusesSearchBookingInfoStore';

import * as i18nBlock from 'i18n/buses-BookingInfoModalError';

import ErrorModal, {TErrorActionType} from 'components/ErrorModal/ErrorModal';
import TicketImg from 'components/UpdateNotification/icons/ticket.svg';

interface IBookingInfoModalErrorProps {
    bookingInfo: IBusesSearchBookingInfoStore;
    onSearch(): void;
}

const IMAGE = <img src={TicketImg} alt="ticket" />;

/**
 * @depricated - компонент был нужен до переезда BOY автобусов на портал,
 * осталось его аккуратно удалить со страницы поиска
 */
const BookingInfoModalError: React.FC<IBookingInfoModalErrorProps> = props => {
    const {bookingInfo, onSearch} = props;

    const status = bookingInfo.value?.status;

    const title = useMemo(() => {
        if (status === EBusesSearchBookingInfoStatus.BAD_GATEWAY) {
            return i18nBlock.bookingError();
        }

        return i18nBlock.searchExpired();
    }, [status]);

    const text = useMemo(() => {
        if (status === EBusesSearchBookingInfoStatus.BAD_GATEWAY) {
            return i18nBlock.refreshSearch();
        }

        return i18nBlock.noTickets();
    }, [status]);

    const action = useMemo((): TErrorActionType => {
        return {
            type: 'button',
            title: i18nBlock.refreshSearchButton(),
            handler: onSearch,
        };
    }, [onSearch]);

    return (
        <ErrorModal
            title={title}
            text={text}
            isVisible={Boolean(
                status &&
                    status !==
                        EBusesSearchBookingInfoStatus.INTERVAL_SERVER_ERROR &&
                    status !== EBusesSearchBookingInfoStatus.OK,
            )}
            image={IMAGE}
            primaryAction={action}
        />
    );
};

export default React.memo(BookingInfoModalError);
