import React, {useMemo} from 'react';
import {useLocation} from 'react-router-dom';

import {IBusesFilledContext} from 'types/buses/common/IBusesContext';

import getSearchUrl from 'projects/buses/utilities/urls/getSearchUrl';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import getSearchQuery from 'projects/buses/utilities/search/getSearchQuery';

import * as i18nCommonBlock from 'i18n/common';
import * as i18nCommonDisclaimerBlock from 'i18n/common_disclaimer';
import * as i18nSearchPageBlock from 'i18n/buses-SearchPage';

import LinkBackward from 'components/LinkBackward/LinkBackward';
import FooterBreadcrumbs from 'projects/buses/pages/search/components/Footer/components/FooterBreadcrumbs/FooterBreadcrumbs';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

import cx from './Footer.scss';

interface IFooterProps {
    context: IBusesFilledContext;
    nonce: string;
}

const Footer: React.FC<IFooterProps> = props => {
    const {context, nonce} = props;

    const deviceType = useDeviceType();
    const location = useLocation();

    const {date} = getSearchQuery(location);

    const backwardLink = useMemo(
        () =>
            getSearchUrl({
                fromSlug: context.to.slug,
                toSlug: context.from.slug,
            }),
        [context],
    );

    return (
        <Flex
            className={cx(deviceMods('root', deviceType))}
            flexDirection="column"
            between={2}
        >
            <LinkBackward
                className={cx('linkBackward')}
                title={i18nSearchPageBlock.linkBackward({
                    direction: i18nCommonBlock.direction({
                        from: context.to.popularTitle || context.to.title,
                        to: context.from.popularTitle || context.from.title,
                    }),
                })}
                to={backwardLink}
            />

            <Text size="s" color="secondary">
                {i18nCommonDisclaimerBlock.fee()}
            </Text>

            <FooterBreadcrumbs
                context={context}
                showDateItem={Boolean(date)}
                nonce={nonce}
                city={context.from}
            />
        </Flex>
    );
};

export default React.memo(Footer);
